(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      4943,        178]
NotebookOptionsPosition[      4284,        150]
NotebookOutlinePosition[      4677,        167]
CellTagsIndexPosition[      4634,        164]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
 ".NET/Link Example: AnimationWindow\n\n",
 StyleBox["This is a very simple example that demonstrates using ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[".NET/Link",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["'s ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["MathPictureBox",
  FontFamily->"Arial",
  FontSize->12,
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" class to display ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" graphics and typeset results in a .NET window.\n\nThe program \
displays a simple window that runs a ",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["Mathematica",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontSlant->"Italic",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox[" animation. This can be useful because it allows you to see an \
animation without generating and storing all the frames in a notebook. \
Because the frames are computed as they are displayed, the speed of the \
animation will suffer if the computations are time-consuming or the graphics \
are very large.\n\n",
  FontFamily->"Arial",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}],
 StyleBox["To try this example, evaluate all the initialization cells (you \
can do this with the menu command Kernel/Evaluation/Evaluate Initialization). \
Then go to the Example section.",
  FontSize->12,
  FontWeight->"Plain",
  FontVariations->{"CompatibilityType"->0}]
}], "Title"],

Cell[CellGroupData[{

Cell["Code and Discussion", "Section"],

Cell["\<\
Needs[\"NETLink`\"];

SetAttributes[AnimationWindow, HoldFirst];
Options[AnimationWindow] = {WindowSize -> {300, 300}, Format -> Automatic, \
FramePause -> 0};

AnimationWindow[func_, range_, opts___?OptionQ] :=
\tNETBlock[
    \tModule[{form, box, funcStr, size, pauseTime},
\t\t\t{size, pauseTime} = {WindowSize, FramePause} /. Flatten[{opts}] /. \
Options[AnimationWindow];
    \t\tform = NETNew[\"System.Windows.Forms.Form\"];
    \t\tform@Width = size[[1]];
    \t\tform@Height = size[[2]];
    \t\tbox = NETNew[\"Wolfram.NETLink.UI.MathPictureBox\"];
    \t\tbox@Parent = form;
\t\t\tLoadNETType[\"System.Windows.Forms.DockStyle\"];
\t\t\tLoadNETType[\"System.Drawing.Color\"];
    \t\tbox@Dock = DockStyle`Fill;
    \t\tbox@BackColor = Color`White;
\t\t\tbox@PictureType = Format /. Flatten[{opts}] /. Options[AnimationWindow] \
/. Automatic -> \"Automatic\";
\t\t\tShowNETWindow[form];
\t\t\tfuncStr = ToString[Unevaluated[func], InputForm];
      \t\tDo[
      \t\t\tbox@MathCommand = funcStr;
      \t\t\tPause[pauseTime];
      \t\t\tIf[form@IsDisposed, Break[]],
      \t\t\trange
\t\t\t]
\t\t]
\t]\
\>", "Input",
 InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Example", "Section"],

Cell["\<\
AnimationWindow[
\tPlot3D[BesselJ[0, Sqrt[x^2+y^2]+t], {x,-10,10}, {y,-10,10}, Axes \[Rule] \
False, PlotRange \[Rule] {-0.5, 1.0}],
\t{t, 0, 20}
]\
\>", "Input"],

Cell["Try resizing while the animation is running.", "Text"],

Cell["\<\
AnimationWindow[
\tExpand[(x+y)^t],
\t{t,0,30},
\tFormat -> \"StandardForm\", FramePause -> 0.2
]\
\>", "Input"]
}, Open  ]]
}, Open  ]]
},
AutoGeneratedPackage->None,
WindowSize->{987, 664},
WindowMargins->{{1, Automatic}, {Automatic, 0}},
DockedCells->(None& ),
FrontEndVersion->"6.0 for Mac OS X PowerPC (32-bit) (February 21, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 2012, 60, 296, "Title"],
Cell[CellGroupData[{
Cell[2627, 87, 38, 0, 67, "Section"],
Cell[2668, 89, 1162, 34, 534, "Input",
 InitializationCell->True]
}, Closed]],
Cell[CellGroupData[{
Cell[3867, 128, 26, 0, 37, "Section"],
Cell[3896, 130, 172, 6, 63, "Input"],
Cell[4071, 138, 60, 0, 26, "Text"],
Cell[4134, 140, 122, 6, 76, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

